// @input Component.InteractionComponent triggerGoodRequestInteraction
// @input Component.InteractionComponent triggerValidationErrorInteraction
// @input Component.InteractionComponent triggerHttpErrorInteraction
// @input Component.Text output
// @input Asset.RemoteServiceModule catFactsModule

script.triggerGoodRequestInteraction.onTouchStart.add(function(eventData) {
    // It is expected that this URL is allowed by a Remote API spec
    makeRequest("Get", "https://catfact.ninja/fact");
});

script.triggerValidationErrorInteraction.onTouchStart.add(function(eventData) {
    // It is expected that this HTTP method is not allowed by a Remote API spec
    makeRequest("Post", "https://catfact.ninja/fact");
});

script.triggerHttpErrorInteraction.onTouchStart.add(function(eventData) {
    // It is expected that this HTTP is allowed by the Remote API spec, but doesn't exist on the target server
    makeRequest("Delete", "https://catfact.ninja/fact");
});

function makeRequest(method, url) {   
    script.output.text = "Loading cat fact...";

    try {
        const req = RemoteServiceHttpRequest.create();
        req.url = url;
        req.method = RemoteServiceHttpRequest.HttpRequestMethod[method];
        
        script.catFactsModule.performHttpRequest(req, (res) => {
            script.output.text = JSON.stringify({
                statusCode: res.statusCode,
                body: res.body,
                contentType: res.contentType,
                headers: res.headers
            }, null, 2);
        });
    } catch (error) {
        script.output.text = error + "";
    }
}
